'Multi-pattern,Multi-speed Chaser
'Bascom-Avr IDE [2.0.7.5]
'Flash used: 1280 bytes
'Micro:ATmega8a
'Written by: Mohammad Moridi

'--------------------------------

$regfile = "m8adef.dat"
$crystal = 1000000

'--------------------------------

Config Portd = Output : Leds Alias Portd

Config Portc = Output : Cathodes Alias Portc : Cathodes = 255

'--------------------------------

Dim Rotation_delay As Byte , Increment As Bit

Dim Mode2_delay As Byte , Speed As Byte

Dim Count As Byte , Line_1 As Word , Line_2 As Word

Dim Line_3 As Word , Line_4 As Word

Dim Threshold As Word , Which_line As Byte

Dim Current_line As Byte

'--------------------------------

Declare Sub Initialization

Declare Sub Mode1 : Declare Sub Ports1 : Declare Sub Ports2

Declare Sub Mode2 : Declare Sub Ports3

Declare Sub Reset_lines : Declare Sub Increase_lines

Declare Sub Current_line_selector

'--------------------------------

Do

   Call Initialization
   Call Mode1


   Call Initialization
   Call Mode2

Loop

'--------------------------------

Sub Initialization

   Call Reset_lines

   Rotation_delay = 4

   Increment = 1

   Mode2_delay = 2

   Speed = 0

   Count = 0

End Sub

'--------------------------------

Sub Mode1

   Do

     If Line_4 => 6 Then
         Call Ports2
     Else
         Call Ports1
     End If

     Threshold = 6

     Call Increase_lines

   Loop Until Line_4 = 8

End Sub

'--------------------------------

Sub Ports1

   For Which_line = 1 To 4 Step 1

      Call Current_line_selector

      Gosub Mode1_lookup_sub

   Next

End Sub

'--------------------------------

Sub Ports2

   For Which_line = 4 To 1 Step -1

      Call Current_line_selector

      Gosub Mode1_lookup_sub

   Next

End Sub

'--------------------------------

Mode1_lookup_sub:

   Leds = Lookup(current_line , First_type_bits)

   Gosub Set_Mode1_delay

   Leds = 0

Return

'--------------------------------

Set_Mode1_delay:

   Incr Speed

   Waitms Rotation_delay

   If Speed >= 20 Then

      Speed = 0

      If Increment = 1 Then
         Rotation_delay = Rotation_delay + 20
      Else
         Rotation_delay = Rotation_delay - 20
      End If


      If Rotation_delay >= 241 Then
         Increment = 0
      End If

      If Rotation_delay <= 1 Then
         Increment = 1
      End If


   End If

Return

'--------------------------------

Sub Mode2

  Do
      Call Ports3

      Gosub Set_Mode2_delay

      Threshold = Mode2_delay

      Call Increase_lines

   Loop Until Line_4 = 279

End Sub

'--------------------------------

Sub Ports3

   For Which_line = 1 To 4 Step 1

      Call Current_line_selector

      Gosub Mode2_lookup_sub

   Next

End Sub

'--------------------------------

Mode2_lookup_sub:

   Leds = Lookup(current_line , Second_type_bits)

   Waitms 4

   Leds = 0

Return

'--------------------------------

Set_Mode2_delay:

      Incr Speed

      If Speed >= 60 Then

         Speed = 0

         If Mode2_delay =< 2 Then
            Increment = 1
         End If

         If Mode2_delay => 16 Then
            Increment = 0
         End If

         If Increment = 1 Then
            Mode2_delay = Mode2_delay + 2
         Else
            Mode2_delay = Mode2_delay - 2
         End If

      End If

Return

'--------------------------------

Sub Reset_lines

      Line_1 = 0

      Line_2 = 0

      Line_3 = 0

      Line_4 = 0

End Sub

'--------------------------------

Sub Increase_lines

     Incr Count

     If Count => Threshold Then

        Incr Line_1

        Incr Line_2

        Incr Line_3

        Incr Line_4

        Count = 0

     End If

End Sub

'--------------------------------

Sub Current_line_selector

   Select Case Which_line

      Case 1
         Cathodes = 223 : Current_line = Line_1

      Case 2
         Cathodes = 239 : Current_line = Line_2

      Case 3
         Cathodes = 247 : Current_line = Line_3

      Case 4
         Cathodes = 251 : Current_line = Line_4

   End Select

End Sub

'--------------------------------


'The lines rotate clockwise and counterclockwiise with different speeds.

First_type_bits:

    Data 255 , 254 , 252 , 248 , 231 , 195 , 15 , 255

'--------------------------------

Second_type_bits:

   'Pattern 1: One LED on at a time.

   Data 1 , 2 , 4 , 8 , 16 , 32 , 64 , 128

   Data 64 , 32 , 16 , 8 , 4 , 2 , 2 , 1



   'Pattern 2 : Two LEDs on at a time.

   Data 192 , 96 , 48 , 24 , 12 , 6 , 6 , 3



   'Pattern 3: Three LEDs on at a time.

   Data 7 , 7 , 14 , 28 , 28 , 56 , 112 , 224



   'Patten 4: Four LEDs on at a time.

   Data 240 , 15 , 240 , 15 , 240 , 15 , 240 , 15

   Data 60 , 195 , 60 , 195 , 60 , 195 , 60 , 195



   'Patten 5 : Four LEDs blink.

   Data 85 , 170 , 85 , 170 , 51 , 204 , 51 , 204

   Data 204 , 51 , 204 , 51 , 170 , 85 , 170 , 85



   'Pattern 6 : All LEDs are initially on and then are turned off two by two.

   Data 255 , 252 , 243 , 207 , 63 , 207 , 243 , 252

   Data 63 , 207 , 243 , 252 , 255 , 252 , 243 , 207



   'Pattern 7: All LEDs are first on and then turned off one by one.

   Data 255 , 254 , 252 , 248 , 240 , 224 , 192 , 128

   Data 255 , 127 , 63 , 31 , 15 , 7 , 3 , 1

   Data 255 , 254 , 252 , 248 , 240 , 224 , 192 , 128

   Data 255 , 127 , 63 , 31 , 15 , 7 , 3 , 1



   'Pattern 8 : One LED is on first. then with left and right shift

   'two, three, four, an up to 8 LEDs are left and right shifted

   Data 1 , 2 , 4 , 8 , 16 , 32 , 64 , 128

   Data 192 , 96 , 48 , 24 , 12 , 6 , 3 , 7



   Data 14 , 28 , 56 , 112 , 224 , 240 , 120 , 60

   Data 30 , 15 , 31 , 62 , 124 , 248 , 252 , 126



   Data 63 , 127 , 254 , 127 , 63 , 126 , 252 , 248

   Data 124 , 62 , 31 , 15 , 30 , 60 , 120 , 240



   Data 224 , 112 , 56 , 28 , 14 , 7 , 3 , 6

   Data 12 , 24 , 48 , 96 , 192 , 128 , 64 , 32



   Data 16 , 8 , 4 , 2 , 1 , 2 , 4 , 8

   Data 16 , 32 , 64 , 128 , 192 , 96 , 48 , 24



   Data 12 , 6 , 3 , 7 , 14 , 28 , 56 , 112

   Data 224 , 240 , 120 , 60 , 30 , 15 , 31 , 62



   Data 124 , 248 , 252 , 126 , 63 , 127 , 254 , 127

   Data 63 , 126 , 252 , 248 , 124 , 62 , 31 , 15



   Data 30 , 60 , 120 , 240 , 224 , 112 , 56 , 28

   Data 14 , 7 , 3 , 6 , 12 , 24 , 48 , 96



   Data 192 , 128 , 64 , 32 , 16 , 8 , 4 , 2

   Data 1 , 2 , 4 , 8 , 16 , 32 , 64 , 128


   '--------------------------------

   'Pattern 9: All LEDs flash.

   Data 255 , 0 , 255 , 0 , 255 , 0 , 255 , 0

   Data 255 , 85 , 170 , 255 , 85 , 170 , 255 , 85

   Data 255 , 85 , 170 , 192 , 96 , 7 , 14 , 255


   '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

'END OF PROGRAM